////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 12/14/2016	ELL
// Revised: 8/28/2020	ELL
// Added ability to expand menu horizontally.
// Added ability to operate second menu and have it expand either horizontally or vertically.

 var menu_height;
 var step = 10;
 if (typeof max_menu_height == 'undefined')
	 var max_menu_height = 640;
 else if (max_menu_height == "")
 	 max_menu_height = 640;
 if (typeof hamburger_menu_num == 'undefined')
	 var hamburger_menu_num = 1;
 else if ((hamburger_menu_num == "") || (hamburger_menu_num == 0))
 	 hamburger_menu_num = 1;
 var timer;
 var interval = 5;
 var menu_div = "menu_div" + hamburger_menu_num;

 if (typeof expand_horizontal == 'undefined')
   var expand_horizontal = false;

 var top_max_menu_height = max_menu_height;
 var top_hamburger_menu_num = hamburger_menu_num;
 var top_expand_horizontal = expand_horizontal;

 function HideMenu()
 {
		if (is_mobile)	{
          	if (expand_horizontal)
				document.getElementById(menu_div).style.width = "0px";
          	else
              	document.getElementById(menu_div).style.height = "0px";
			document.getElementById(menu_div).style.overflow = "hidden";
	   }
 }

 function ShowHideMobileMenu()
 {
   if (expand_horizontal)
   {
     menu_div = "menu_div" + hamburger_menu_num;
     
	 var img_src = document.getElementById("horiz_show_hide_mobile_menu_img").src;
	 if (img_src.indexOf("menu-icon.png") > -1)	{
			 document.getElementById("horiz_show_hide_mobile_menu_img").src = image_dir + "horiz-menu-close-icon.png";
			 menu_height = 0;
			 timer = setInterval(ExpandMenu, interval);
	 }
	 else	{
		 document.getElementById("horiz_show_hide_mobile_menu_img").src = image_dir + "horiz-menu-icon.png";
		 menu_height = max_menu_height;
		 timer = setInterval(CollapseMenu, interval);
	}
   }
   else
   {
	 var img_src = document.getElementById("show_hide_mobile_menu_img").src;
	 if (img_src.indexOf("menu-icon.png") > -1)	{
			 document.getElementById("show_hide_mobile_menu_img").src = image_dir + "menu-close-icon.png";
			 menu_height = 0;
			 timer = setInterval(ExpandMenu, interval);
	 }
	 else	{
		 document.getElementById("show_hide_mobile_menu_img").src = image_dir + "menu-icon.png";
		 menu_height = max_menu_height;
		 timer = setInterval(CollapseMenu, interval);
	}
   }
 }

 function ExpandMenu()
 {
	   if (menu_height < max_menu_height)	{
			menu_height = menu_height + step;
         	if (expand_horizontal)
				document.getElementById(menu_div).style.width = menu_height + "px";
         	else
            	document.getElementById(menu_div).style.height = menu_height + "px";
	   }
	   else	{
		   clearInterval(timer);
		   document.getElementById(menu_div).style.overflow = "visible";
         
           if (expand_horizontal)	{
		     max_menu_height = top_max_menu_height;
          	 hamburger_menu_num = top_hamburger_menu_num;
             expand_horizontal = false;
             menu_div = "menu_div" + top_hamburger_menu_num;
           }
	   }
 }

 function CollapseMenu()
 {
	 if (menu_height == max_menu_height)
			document.getElementById(menu_div).style.overflow = "hidden";
	   if (menu_height > 0)	{
			menu_height = menu_height - step;
         	if (expand_horizontal)
				document.getElementById(menu_div).style.width = menu_height + "px";
         	else
              	document.getElementById(menu_div).style.height = menu_height + "px";
	   }
	   else	{
			clearInterval(timer);
         	if (expand_horizontal)
				document.getElementById(menu_div).style.width = "0px";
         	else
            	document.getElementById(menu_div).style.height = "0px";
         
         	if (expand_horizontal)	{
		     max_menu_height = top_max_menu_height;
          	 hamburger_menu_num = top_hamburger_menu_num;
             expand_horizontal = top_expand_horizontal;
             menu_div = "menu_div" + top_hamburger_menu_num;
           }
	   }
 }

HideMenu();